# File: library.py

class Library:

    def __init__(self):
        """
        Creates a new instance of the Library class
        """
        self.library = []   # instance variable to keep track of the book titles

    def return_book(self, title):
        """
        Returns a book with the given title to the library
        """
        self.library.append(title)

    def check_out(self, title):
        """
        Removes a book with the given title from the library, or prints
        'No book with that title' if that book isn't found
        """
        if title in self.library:
            self.library.remove(title)
        else:
            print('No book with that title')

    def get_catalog(self):
        """
        Returns a list of all books currently in the library, sorted
        alphabetically
        """
        return sorted(self.library)